#include <Arduino.h>

// defines pins numbers
const int trigPin = 4;
const int echoPin = 5;
#define LED 2

// defines variables
long duration;
int distance;
int timer;
int playing = 0;


void setup() {
pinMode(trigPin, OUTPUT); // Sets the trigPin as an Output
pinMode(echoPin, INPUT); // Sets the echoPin as an Input
pinMode(LED,OUTPUT);
Serial.begin(9600); // Starts the serial communication
}


void loop() {
  // Clears the trigPin
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  
  // Sets the trigPin on HIGH state for 10 micro seconds
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
  
  // Reads the echoPin, returns the sound wave travel time in microseconds
  duration = pulseIn(echoPin, HIGH);
  
  // Calculating the distance
  distance= duration*0.034/2;
  
  // Prints the distance on the Serial Monitor
  Serial.print("Distance: ");
  Serial.println(distance);

  // LED blinks fast within 1.5 meter and slow between 1.5 - 2 meter
  if( distance <= 150 )
  {
      delay(timer);
      digitalWrite(LED, HIGH);
      delay(timer);
      digitalWrite(LED, LOW);

      timer = distance * 2;
  }
  else if(distance <=200)
  {
      delay(500);
      digitalWrite(LED, HIGH);
      delay(500);
      digitalWrite(LED, LOW);
  }
  else
  {
    digitalWrite(LED, LOW);
  }
}
